/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.analog;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.AbstractFlags8;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.analog.ConstantComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.RegistryObject;

public abstract class OperatorComponentBase
extends CircuitComponentBase<OperatorComponentBase> {
    public static final VecDirectionFlags INPUT_SIDES = (VecDirectionFlags)VecDirectionFlags.horizontals().and((Enum)VecDirection.NEG_Y);
    private static final VecDirectionFlags OUTPUT_SIDES = VecDirectionFlags.horizontals();
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final Property<VecDirection> PROP_DIRECTION = EnumProperty.m_61598_((String)"direction", VecDirection.class, (Enum[])new VecDirection[]{VecDirection.NEG_X, VecDirection.POS_X, VecDirection.NEG_Z, VecDirection.POS_Z});
    private static final InterfaceLookup<OperatorComponentBase> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, OperatorComponentBase::getRedstoneSource).with(RedstoneSink.class, INPUT_SIDES, RedstoneSink::instance).build();
    private VecDirection direction = VecDirection.NEG_X;
    private int output;
    private int extra;

    public OperatorComponentBase(RegistryObject<ComponentType> type, ComponentContext context) {
        super(type, context, INTERFACES);
    }

    protected abstract int[] operate(int var1, int var2);

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_DIRECTION, (Comparable)this.direction);
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public int getExtraOutput() {
        return this.extra;
    }

    public void onAdded() {
        super.onAdded();
        this.scheduleTick(1);
    }

    public void update(ComponentEventMap events, boolean tick) {
        if (!this.ensureSupported(events)) {
            return;
        }
        if (tick) {
            int[] newValues = this.operate(this.getMainInput(), this.getSecondaryInput());
            this.updateExternalState(false, () -> {
                this.output = newValues[0];
                this.extra = newValues[1];
            });
            this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
        }
        if (!((VecDirectionFlags)events.findAny(new CircuitEvent[]{CircuitEvent.NEIGHBOR_CHANGED, CircuitEvent.REDSTONE}).onlyIn((AbstractFlags8)INPUT_SIDES)).isEmpty()) {
            this.scheduleTick(1);
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_204117_(TKLibItemTags.TOOLS_WRENCH)) {
            VecDirection newDirection = this.direction.applyY(Rotation.CLOCKWISE_90);
            this.updateExternalState(true, () -> {
                this.direction = newDirection;
            });
            this.sendEvent(CircuitEvent.NEIGHBOR_CHANGED, OUTPUT_SIDES);
            this.scheduleTick(1);
            return InteractionResult.m_19078_((boolean)false);
        }
        return super.use(player, hand, sideHit, hit);
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("direction", this.direction.ordinal());
        tag.m_128405_("output", this.output);
        tag.m_128405_("extra", this.extra);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.direction = VecDirection.VALUES[tag.m_128451_("direction")];
        this.output = tag.m_128451_("output");
        this.extra = tag.m_128451_("extra");
    }

    private int getMainInput() {
        CircuitComponent neighbor = this.findNeighbor(this.direction);
        if (neighbor instanceof OperatorComponentBase || neighbor instanceof ConstantComponent) {
            return this.getWeakInput(this.direction);
        }
        return this.getStrongInput(this.direction);
    }

    private int getSecondaryInput() {
        return ((VecDirectionFlags)INPUT_SIDES.except((Enum)this.direction)).stream().mapToInt(x$0 -> this.getStrongInput((VecDirection)x$0)).max().orElse(0);
    }

    private RedstoneSource getRedstoneSource(VecDirection side) {
        if (side == this.direction) {
            return null;
        }
        return RedstoneSource.of((int)0, (int)this.output);
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_DIRECTION});
    }

    public static class Client
    extends ClientComponent {
        private final RegistryObject<Item> item;

        public Client(RegistryObject<Item> item) {
            this.item = item;
        }

        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)this.item.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && stack.m_204117_(TKLibItemTags.TOOLS_WRENCH)) {
                return InteractionResult.m_19078_((boolean)true);
            }
            return super.use(state, player, hand, sideHit, hit);
        }
    }
}

